#ifndef _DX_VOS_SECURE_STORAGE_H
#define _DX_VOS_SECURE_STORAGE_H


#ifdef __cplusplus
extern "C"
{
#endif


#include "DX_VOS_BaseTypes.h"

typedef DxStatus (*DxSaveSecureItemFunc)(DxUint32 itemId, const void* data, DxUint32 dataSize);
typedef DxStatus (*DxGetSecureItemSizeFunc)(DxUint32 itemId, DxUint32* dataSize);
typedef DxStatus (*DxLoadSecureItemFunc)(DxUint32 itemId, void* data, DxUint32 dataSize, DxUint32* dataActuallyRead);
typedef DxStatus (*DxDeleteSecureItemFunc)(DxUint32 itemId);

DxStatus DX_VOS_SaveSecureItem(DxUint32 itemId, const void* data, DxUint32 dataSize);

DxStatus DX_VOS_GetSecureItemSize(DxUint32 itemId, DxUint32* dataSize);

DxStatus DX_VOS_LoadSecureItem(DxUint32 itemId, void* data, DxUint32 dataSize, DxUint32* dataActuallyRead);

DxStatus DX_VOS_DeleteSecureItem(DxUint32 itemId);

void DX_VOS_SetSaveSecureItemFunc(DxSaveSecureItemFunc saveSecureItemFunc);

void DX_VOS_SetGetSecureItemSizeFunc(DxGetSecureItemSizeFunc getSecureItemSizeFunc);

void DX_VOS_SetLoadSecureItemFunc(DxLoadSecureItemFunc loadSecureItemFunc);

void DX_VOS_SetDeleteSecureItemFunc(DxDeleteSecureItemFunc deleteSecureItemFunc);

#ifdef __cplusplus
}
#endif

#endif
